# AI Chat Widget - إضافة ووردبريس للدردشة الذكية

نافذة دردشة ذكية للرد على العملاء باستخدام الذكاء الاصطناعي.

## المميزات

- ✅ دعم OpenAI (GPT-4o, GPT-4, GPT-3.5)
- ✅ دعم DeepSeek (Chat, Coder, Reasoner)
- ✅ قاعدة معرفة مخصصة
- ✅ تعليمات مخصصة للبوت
- ✅ تصميم متجاوب (Desktop, Tablet, Mobile)
- ✅ دعم RTL والعربية
- ✅ تخصيص الألوان والمظهر
- ✅ سجل المحادثات والإحصائيات
- ✅ Rate Limiting للحماية
- ✅ متوافق مع WordPress 6.0+

## التثبيت

1. ارفع مجلد `ai-chat-widget` إلى `/wp-content/plugins/`
2. فعّل الإضافة من لوحة تحكم WordPress
3. اذهب إلى **AI Chat Widget** في القائمة الجانبية
4. أدخل مفتاح API وابدأ الإعداد

## الإعداد

### 1. مزود الذكاء الاصطناعي

اختر بين:
- **OpenAI**: احصل على مفتاح API من [platform.openai.com](https://platform.openai.com/api-keys)
- **DeepSeek**: احصل على مفتاح API من [platform.deepseek.com](https://platform.deepseek.com/)

### 2. قاعدة المعرفة

أضف معلومات عن:
- معلومات الشركة
- المنتجات والخدمات
- الأسعار
- ساعات العمل
- الأسئلة الشائعة

### 3. تعليمات البوت

حدد:
- شخصية البوت
- أسلوب الرد
- القيود والتوجيهات

### 4. المظهر

خصص:
- الألوان
- موضع النافذة
- اسم البوت
- صورة البوت
- رسالة الترحيب

## هيكل الملفات

```
ai-chat-widget/
├── ai-chat-widget.php          # الملف الرئيسي
├── readme.txt                   # ملف WordPress readme
├── README.md                    # هذا الملف
├── includes/
│   ├── class-admin-settings.php # صفحة الإعدادات
│   ├── class-ai-providers.php   # مزودي AI
│   ├── class-chat-handler.php   # معالجة الرسائل
│   └── class-knowledge-base.php # قاعدة المعرفة
├── assets/
│   ├── css/
│   │   ├── admin-style.css      # ستايلات لوحة التحكم
│   │   └── chat-widget.css      # ستايلات النافذة
│   └── js/
│       ├── admin-script.js      # سكربت لوحة التحكم
│       └── chat-widget.js       # سكربت النافذة
├── templates/
│   └── chat-window.php          # قالب النافذة
└── languages/                   # ملفات الترجمة
```

## المتطلبات

- WordPress 6.0 أو أحدث
- PHP 8.0 أو أحدث
- مفتاح API من OpenAI أو DeepSeek

## الترخيص

GPL v2 or later

## الدعم

للمساعدة أو الإبلاغ عن مشاكل، تواصل معنا.
