<?php
/**
 * قالب نافذة الدردشة
 * 
 * @package AI_Chat_Widget
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$settings = get_option('aicw_settings', array());
$position = $settings['widget_position'] ?? 'right';
$bot_name = $settings['bot_name'] ?? __('المساعد الذكي', 'ai-chat-widget');
$bot_avatar = $settings['bot_avatar'] ?? '';
$primary_color = $settings['primary_color'] ?? '#0073aa';
?>

<!-- AI Chat Widget -->
<div id="aicw-chat-widget" class="aicw-widget aicw-position-<?php echo esc_attr($position); ?>" dir="<?php echo is_rtl() ? 'rtl' : 'ltr'; ?>">
    
    <!-- زر فتح الدردشة -->
    <button id="aicw-chat-toggle" class="aicw-chat-toggle" aria-label="<?php esc_attr_e('فتح الدردشة', 'ai-chat-widget'); ?>">
        <svg class="aicw-icon-chat" viewBox="0 0 24 24" fill="currentColor" width="28" height="28">
            <path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17L4 17.17V4h16v12z"/>
            <path d="M7 9h10v2H7zm0-3h10v2H7zm0 6h7v2H7z"/>
        </svg>
        <svg class="aicw-icon-close" viewBox="0 0 24 24" fill="currentColor" width="28" height="28" style="display:none;">
            <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
        </svg>
        <span class="aicw-unread-badge" style="display:none;">0</span>
    </button>
    
    <!-- نافذة الدردشة -->
    <div id="aicw-chat-window" class="aicw-chat-window" style="display:none;">
        
        <!-- رأس النافذة -->
        <div class="aicw-chat-header">
            <div class="aicw-header-info">
                <?php if (!empty($bot_avatar)) : ?>
                    <img src="<?php echo esc_url($bot_avatar); ?>" alt="" class="aicw-bot-avatar">
                <?php else : ?>
                    <div class="aicw-bot-avatar aicw-bot-avatar-default">
                        <svg viewBox="0 0 24 24" fill="currentColor" width="24" height="24">
                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"/>
                        </svg>
                    </div>
                <?php endif; ?>
                <div class="aicw-header-text">
                    <span class="aicw-bot-name"><?php echo esc_html($bot_name); ?></span>
                    <span class="aicw-status">
                        <span class="aicw-status-dot"></span>
                        <?php _e('متصل', 'ai-chat-widget'); ?>
                    </span>
                </div>
            </div>
            <div class="aicw-header-actions">
                <button type="button" class="aicw-btn-minimize" aria-label="<?php esc_attr_e('تصغير', 'ai-chat-widget'); ?>">
                    <svg viewBox="0 0 24 24" fill="currentColor" width="20" height="20">
                        <path d="M19 13H5v-2h14v2z"/>
                    </svg>
                </button>
                <button type="button" class="aicw-btn-close" aria-label="<?php esc_attr_e('إغلاق', 'ai-chat-widget'); ?>">
                    <svg viewBox="0 0 24 24" fill="currentColor" width="20" height="20">
                        <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
                    </svg>
                </button>
            </div>
        </div>
        
        <!-- منطقة الرسائل -->
        <div id="aicw-messages" class="aicw-messages">
            <!-- الرسائل ستظهر هنا -->
        </div>
        
        <!-- مؤشر الكتابة -->
        <div id="aicw-typing" class="aicw-typing" style="display:none;">
            <div class="aicw-typing-indicator">
                <span></span>
                <span></span>
                <span></span>
            </div>
            <span class="aicw-typing-text"><?php _e('جاري الكتابة...', 'ai-chat-widget'); ?></span>
        </div>
        
        <!-- حقل الإدخال -->
        <div class="aicw-input-area">
            <form id="aicw-chat-form" class="aicw-chat-form">
                <div class="aicw-input-wrapper">
                    <textarea 
                        id="aicw-input" 
                        class="aicw-input" 
                        placeholder="<?php esc_attr_e('اكتب رسالتك هنا...', 'ai-chat-widget'); ?>"
                        rows="1"
                        maxlength="1000"
                    ></textarea>
                    <button type="submit" id="aicw-send" class="aicw-send-btn" disabled aria-label="<?php esc_attr_e('إرسال', 'ai-chat-widget'); ?>">
                        <svg viewBox="0 0 24 24" fill="currentColor" width="24" height="24">
                            <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>
                        </svg>
                    </button>
                </div>
            </form>
            <div class="aicw-powered-by">
                <?php _e('مدعوم بالذكاء الاصطناعي', 'ai-chat-widget'); ?>
            </div>
        </div>
        
    </div>
    
</div>

<!-- CSS المخصص -->
<style>
:root {
    --aicw-primary: <?php echo esc_attr($primary_color); ?>;
    --aicw-secondary: <?php echo esc_attr($settings['secondary_color'] ?? '#ffffff'); ?>;
}
</style>
